# Contributing to Go

Go is an open source project.

It is the work of hundreds of contributors. We appreciate your help!


## Filing issues

General questions should go to the
[golang-nuts mailing list](https://groups.google.com/group/golang-nuts) or
[other forum](https://golang.org/wiki/Questions) instead of the issue tracker.
The gophers there will answer or ask you to file an issue if you've tripped over a bug.

When filing an issue, make sure to answer these five questions:

1. What version of Go are you using (`go version`)?
2. What operating system and processor architecture are you using?
3. What did you do?
4. What did you expect to see?
5. What did you see instead?

For change proposals, see [Proposing Changes To Go](https://github.com/golang/proposal/).

Sensitive security-related issues should be reported to [security@golang.org](mailto:security@golang.org).

## Contributing code

Please read the [Contribution Guidelines](https://golang.org/doc/contribute.html)
before sending patches.

**We do not accept GitHub pull requests**
(we use [an instance](https://go-review.googlesource.com/) of the
[Gerrit](https://www.gerritcodereview.com/) code review system instead).
Also, please do not post patches on the issue tracker.

Unless otherwise noted, the Go source files are distributed under
the BSD-style license found in the LICENSE file.

